//Arduino Leonardo or Pro Micro using ATMega32u4    (SerialControlAnalogDev8)
//Serial input control; serial data output streaming; analog light sensor
//Pulse duration measurement; Pulse onset latency measurement
//Place 100 nF capacitor between A0 and GND to reduce noise

const int signalPin = A0;      //phototransistor light detector
const int externalLED = 9;     //Digital line #9
const int digitalInput = 7;    //demo diital input
unsigned long startTime = 0UL;
unsigned long endTime = 0UL;
unsigned long elapsedTime = 0UL;

char data;                   //serial char input data

//operalional parameters
int state = 0;            //operational state: 0=stopped,1=duration,2=latency
int trigger = 0;          //event detection: 0=rising-edge, 1=falling-edge (N/A)
int verbose = 0;          //0=silent, 1=serial output commentary enabled+
int black = 20;           //BLACK photometer level (default)
int white = 100;          //WHITE photometer level (default)
int threshold = 60;       //photometer event detection threshold
int light = 0;            //analog light sensor level
unsigned int microsecs = 500; //ADC delay (microsecs)

void setup() {
  pinMode(externalLED, OUTPUT); //define LED digital output
  pinMode(signalPin, INPUT);    //define photometeer analog input
  pinMode(digitalInput, INPUT_PULLUP); //define a digital input with internal pull-up resistance
  digitalWrite(externalLED, LOW); //LED off
  analogReference(INTERNAL);    //use ATMega324u's internal 2.56V reference for ADC
  for(int i=0; i<10; i++) {     //accommodate change in ADC reference connection
     int temp = analogRead(signalPin);
     delay(50);
  }
  elapsedTime = micros();
  Serial.begin(115200);
  //TXLED0;   //macro turns-off TX LED
  //delayMicroseconds(microsecs);
}

void loop() {

  int loopflag;
  int temp;
  
  ////////////////////////////////////////
  //                                    //
  // posiive-pulse duration measurement //
  //                                    //
  ////////////////////////////////////////
  if( (state==1) && (trigger == 0)) {
    //wait for initial low input signal level
    if(verbose==1) {Serial.println("Waiting for baseline low signal level");}
    loopflag = 1;
    while(loopflag) {
      delayMicroseconds(microsecs);
      temp = analogRead(signalPin);
      if(temp < threshold) {
         loopflag = 0;
         //Serial.print("LOW LEVEL FOUND   "); Serial.println(temp);
      }
      else
      {
         //Serial.print("searching for LOW signal   "); Serial.println(temp);
         scanKey();
      }
      if(state != 1) { break; }
    }
    
    //wait for initial rising-edge
    if(verbose==1) {Serial.println("Scan for initial rising-edge of signal");}
    loopflag = 1;
    while(loopflag) {
      delayMicroseconds(microsecs);
      temp = analogRead(signalPin);
      if(temp > threshold) {
         startTime = micros();  /////// READ EVENT START TIMEE
         //Serial.print("INITIAL POS EDGE DETECTED   "); Serial.println(temp);
         //Serial.println("Scaning for negative-edge   ");
         loopflag = 0;
      }
      else
      {
         //Serial.print("searching for positive edge   "); Serial.println(temp);
         scanKey();
      }
      if(state != 1) { break; }
    }
    
    //wait for negative-edge
    loopflag = 1;
    while(loopflag) {
       delayMicroseconds(microsecs);
       temp = analogRead(signalPin);
       if(temp < threshold) {
          endTime = micros();
          //Serial.print("END OF EVENT DETECTED   "); Serial.println(temp);
          loopflag = 0;
       }
       else
       {
          //Serial.print("searching for negative-edge   "); Serial.println(temp);
          scanKey();
       }
       if(state != 1) { break; }   //end one-shot mode
    }

    //compute and return positive pulse duration
    elapsedTime = endTime - startTime;
    if(state == 1) {Serial.println(elapsedTime);}

    //terminate pulse duration measurement
    //digitalWrite(ledPin, LOW);  //LED off
    state = 0;
    
  } //end one-shot, rising-edge


  ////////////////////////////////////////
  //                                    //
  // posiive-pulse latency measurement  //
  //                                    //
  ////////////////////////////////////////
  if( (state==2) && (trigger == 0)) {

    startTime = micros();   //save scan start time
    //wait for initial rising-edge
    if(verbose==1) {Serial.println("Scan for initial rising-edge of signal");}
    loopflag = 1;
    while(loopflag) {
      delayMicroseconds(microsecs);
      temp = analogRead(signalPin);
      if(temp > threshold) {
         endTime = micros();  //read event detection time
         //Serial.print("POS EDGE DETECTED   "); Serial.println(temp);
         loopflag = 0;
      }
      else
      {
         //Serial.print("searching for positive edge   "); Serial.println(temp);
         scanKey();
      }
      if(state != 2) { break; }
    }

    //compute and return pulse latency
    elapsedTime = endTime - startTime;
    if(state == 2) {Serial.println(elapsedTime);}

    //terminate pulse latency measurement
    //digitalWrite(ledPin, LOW);  //LED off
    state = 0;
    
  } //end of latency scan loop


  //scan for serial input commands
  scanKey();
  
} //end loop()

/////////////////////////////////////////////////////////
//                                                     //
//scan serial input and interpret single-char commands //
//                                                     //
/////////////////////////////////////////////////////////
void scanKey() {
   int min = 1023;
   int max = 0;
   if(Serial.available() > 0) {
       data = Serial.read();   //fetch char from serial input buffer
       //interpret serial input char
       switch(data) {
          case 'p':   //(P)ing command (used for baseline timing benchmarks)
             Serial.print("R");  //immediate single char serial reply
             break;
          case 's':   //(S)top command
             //digitalWrite(ledPin, LOW);
             if(verbose==1) {Serial.println("Measurement stopped"); }
             state = 0;   //operational mode = stopped
             break;
          case 'd':   //(D)uration measurement command
             //digitalWrite(ledPin, HIGH);
             state = 1;   //operational mode = one-shot measurement
             if(verbose==1) {Serial.println("One-shot mode"); }
             break;
          case 'l':   //(L)atency measurement command
             //digitalWrite(ledPin, HIGH);
             if(verbose==1) {Serial.println("Contimuous mode"); }
             state = 2;   //operational mode = continuous measurement
             break;
          case 'b':   //sample stimulus BLACK level and update threshold value
             //int min = 1023;
             //int max = 0;
             Serial.println("Sampling...");
             for(int i=0; i<20; i++) {
               delay(103);
               int temp = analogRead(signalPin);
               //Serial.print("ADC = "); Serial.println(temp);
               if(temp < min) min = temp;
               if(temp > max) max = temp;
               //delay(103);
             }
             black = max;
             threshold = white - ((white-black)/2);
             Serial.print("Black = "); Serial.print(black);
             Serial.print(" Threshold = "); Serial.println(threshold);
             break;
          case 'w':   //sample stimulus WHITE level and update threshold value
             //int min = 1023;
             //int max = 0;
             Serial.println("Sampling...");
             for(int i=0; i<20; i++) {
                delay(103);
                int temp = analogRead(signalPin);
                //Serial.print("ADC = "); Serial.println(temp);
                if(temp < min) min = temp;
                if(temp > max) max = temp;
                //delay(103);
             }
             white = min;
             threshold = white - ((white-black)/2);
             Serial.print("White = "); Serial.print(white);
             Serial.print(" Threshold = "); Serial.println(threshold);
             break;   
          case 'a':   //ADC reading of light sensor input command
             light = analogRead(signalPin);
             Serial.print("Light level = "); Serial.println(light);
             break;
          case 't':   //(T)HRESHOLD report command
             Serial.print("Threshold = "); Serial.print(threshold);
             Serial.print(" Black = "); Serial.print(black);
             Serial.print(" White = "); Serial.println(white);
             break;
          case 'c':   //(C)lock
             startTime = micros();
             Serial.println(startTime);
             break;
          case '0':   //Turn external LED off
             digitalWrite(externalLED, LOW);
             break;
          case '1':   //Turn external LED On
             digitalWrite(externalLED, HIGH);
             break;
          case '7':   //Report state of Digital Input line #7
             Serial.print("D7 = "); Serial.println(digitalRead(digitalInput));
             break;
          case 'h':   //(H)ELP menu command
          case '?':
             Serial.println("Single Charater Commands:");
             Serial.println("  b = sample stimulus BLACK level");
             Serial.println("  w = sample stimulus WHITE level");
             Serial.println("  a = ADC light level (analog photo-sensor)");
             Serial.println("  t = report Threshold level");
             Serial.println("  d = Duration measurement mode");
             Serial.println("  l = Latency measurement mode");
             Serial.println("  s = Stop ongoing measurement operations");
             Serial.println("  p = Ping the Arduino (immediate serial reply");
             Serial.println("  c = Return Arduino Clock (microsecs)");
             Serial.println("  0 = external LED Off");
             Serial.println("  1 = external LED On");
             Serial.println("  7 = read state of Digital Input line #7");
             break;
          default:
             break;
       } //end switch()
    } //end Serial.available()
} //end scanKey()
