#serial_input_test.py   [use Arduino 'serialtest4.ino' for testing]
#Experiment with Arduino-to-Python serial input
#The serialtest4.ino Arduino script prints the system time (millisec)
#to the serial console once per second.  The following Python code
#opens a serial port connection to the Arduino board and captures
#and prints the incoming data to the console.

import serial
import sys, time
from psychopy.hardware import keyboard

COM_PORT = 'COM22'  #Arduino serial port
TO = 2.0            #Serial timeout parameter

#open serial connection to Arduino board
try:
    arduino = serial.Serial(port=COM_PORT,baudrate=115200,timeout=TO)
    #wait for serial port to open
    time.sleep(1.0)
    arduino.reset_input_buffer()
except:
    print('Attempt to open COM port failed.')
    sys.exit()

#fetch serial data from Arduino
def read_serial():
    serial_input = arduino.readline() #NOTE: blocks until timeout
    if len(serial_input) == 0:
       serial_data = -1  #timeout occurred
    else:
       #strip terminator(s) and whitespace
       str = serial_input.strip().decode()
       #convert to numeric format
       serial_data = int(str)
    return serial_data

#collect/display serial input values
print('Collect/Display Arduino Serial Input Data')
print('Press ANY key to exit.')
kb = keyboard.Keyboard()
while True:
    data = read_serial()   #scana serial port for input
    print('Serial input: %d' % data) #print input data
    #exit if keypress detected
    keys = kb.getKeys([], waitRelease=False)
    if len(keys) > 0:
        print('Program terminated.')
        break

#close serial connection when finished
#arduino.close()
#del arduino
