#py2arduino_serial_command.py
#Experiment with Python-to-Arduino serial command output
#Sends a single character command to Arduino
#Use 'serialtest3.ino' sketch on Arduino to demonstrate.

import serial
import time

com_port = 'COM22'    #Arduino serial port (check Device Manager)

#open serial connection to Arduino board
arduino = serial.Serial(port=com_port,baudrate=115200,timeout=0.5)
#wait for serial port to open
time.sleep(1.0)

#send '1' (one) to Arduino serialtest3.ino 
arduino.write(bytes('1','utf-8')) #turn-on built-in LED
#delay 3 seconds
time.sleep(3.0)
#send '0' (zero) to Arduino serialtest3.ino
arduino.write(bytes('0','utf-8')) #turn-off built-in LED
#delay 3 seconds
time.sleep(3.0)
#send '1' to turn-on LED before exiting program
arduino.write(bytes('1','utf-8'))

